const withOffline = require('next-offline');
const path = require('path');

const rewrites = async () => {
    const ret = [
        // {
        //     source: '/openai/:path*',
        //     destination: `${process.env.OPENAI_PROXY_URL || 'https://api.openai.com'}/:path*`,
        // },
        {
            source: '/google-fonts/:path*',
            destination: 'https://fonts.googleapis.com/:path*',
        },
        {
            source: '/sharegpt',
            destination: 'https://sharegpt.com/api/conversations',
        },
        {
            source: '/backend/:path*',
            // destination: 'https://chat-query-backend.onrender.com/:path*',
            destination: `${process.env.NEXT_PUBLIC_BACKEND_URL}/:path*`,
            // destination: 'http://139.198.179.193:30981/:path*',
        },
    ];

    return {
        beforeFiles: ret,
    };
};

/** @type {import('next').NextConfig} */
const nextConfig = {
    transpilePackages: ['@formilyjs/arco'],
    reactStrictMode: true,
    publicRuntimeConfig: {
        apiPath: '/api/',
        backendOrigin: process.env.NEXT_PUBLIC_BACKEND_URL,
    },
    rewrites,
    eslint: {
        ignoreDuringBuilds: true,
    },
    typescript: {
        ignoreBuildErrors: true,
    },
    generateSw: false,
    // dontAutoRegisterSw: true,
    generateInDevMode: true,
    workboxOpts: {
        swSrc: './serviceWorker.js',
        mode: process.env.NODE_ENV,
        swDest: path.resolve(__dirname, './public/service-worker.js'),
        maximumFileSizeToCacheInBytes: 7 * 1024 * 1024,
        include: [
            _ => {
                if (/^static\//.test(_.asset.name) && !/\[.*\]/.test(_.asset.name))
                    console.log(_.asset.name, '333');
                return /^static\//.test(_.asset.name) && !/\[.*\]/.test(_.asset.name);
            },
        ],
    },
    experimental: {
        proxyTimeout: 1000 * 120,
    },
};

module.exports = withOffline(nextConfig);
