# CHAT-QUERY

[zh](./README-zh.md)

> Chat-Query is a data query implementation based on metadata models and AI technology through natural language.

## Demo

> [Online Preview](https://chat-query.vercel.app/)

> [demo gif](https://cdn.glitch.me/fd139a45-4a65-41b6-9634-41617ab20cdc/%E6%BC%94%E7%A4%BA.gif?v=1686907695067)

+ **Features🐂：**

	- Supports DDL, DBML and database reverse parsing import, AI automatically generates business models.
	- Provides basic CRUD functions of business models, AI intelligent analysis, supports model export to DDL, DBML and synchronization with the database.
	- Combines models and AI to implement natural language data queries, can be added to the query list and called via API.
	- BI analysis, Function call, react code sandbox, supports importing npm packages.

## Application Scenarios🎬

+ From low-code to no-code development.
+ Non-business personnel can quickly perform data analysis.
+ More application scenarios to be explored...

## Deployment
+ docker compose

	```shell
	NEXT_PUBLIC_OPEN_AI_API_KEY="sk-..." docker-compose up
	```
+ Both chat-query and chat-query-backend support docker build and provide docker images.

## Development Environment Setup

> 👏 Welcome to participate in the construction of Chat-Query.

+ Backend：

  ```js
		pnpm install
		pnpm start:dev
	```
	- Add in .env file

	```shell
		#openai
		OPEN_AI_API_KEY='sk-...'
		MODEL_NAME="gpt-3.5-turbo-16k-0613"
		BASE_URL='https://open-ai-xyy.deno.dev/v1'
		# database
		DB_HOST="139.198.179.193"
		DB_PORT=32094
	```

+ Frontend

	```js
		pnpm install
		pnpm dev
	```
	- Add in .env file

	```shell
		NEXT_PUBLIC_OPEN_AI_API_KEY='sk-...'
		OPENAI_PROXY_URL="https://open-ai-xyy.deno.dev/"
		NEXT_PUBLIC_BACKEND_URL="http://localhost:3001/"
		NEXT_PUBLIC_ZIWEI_URL="http://staging.fusiontech.cn"
	```

## System Architecture

![Architecture](https://cdn.glitch.global/fd139a45-4a65-41b6-9634-41617ab20cdc/%E6%97%A0%E6%A0%87%E9%A2%98-2023-05-31-1202%20(1).png?v=1686908252244)