async function decryptDataWithPrivateKey(privateKey, encryptedBase64) {
    // 将 Base64 编码的加密数据解码为 ArrayBuffer
    const encryptedData = base64ToArrayBuffer(encryptedBase64);

    // 使用 RSA-OAEP 解密数据
    const decryptedBuffer = await crypto.subtle.decrypt(
        { name: "RSA-OAEP" },
        privateKey, // 使用私钥解密
        encryptedData
    );

    // 将解密后的数据转换为字符串
    return new TextDecoder().decode(decryptedBuffer);
}

// 将 Base64 转换为 ArrayBuffer
function base64ToArrayBuffer(base64) {
    const binaryString = atob(base64);
    const length = binaryString.length;
    const arrayBuffer = new ArrayBuffer(length);
    const uint8Array = new Uint8Array(arrayBuffer);

    for (let i = 0; i < length; i++) {
        uint8Array[i] = binaryString.charCodeAt(i);
    }

    return arrayBuffer;
}

async function importPrivateKey(privateKeyBase64) {
    // 1. Base64 解码（转换为 ArrayBuffer）
    const binaryDer = atob(privateKeyBase64);
    const keyBuffer = new Uint8Array(binaryDer.length).map((_, i) => binaryDer.charCodeAt(i));

    // 2. 使用 Web Crypto API 解析 PKCS#8 私钥
    return await crypto.subtle.importKey(
        "pkcs8",
        keyBuffer.buffer,
        { name: "RSA-OAEP", hash: "SHA-256" }, // 确保 Java 端使用 "RSA-OAEP" 加密
        true,
        ["decrypt"]
    );
}

async function decryptMessage(privateKey, encryptedAesKey) {
    // 导入私钥
    const pk = await importPrivateKey(privateKey);
    // console.log("私钥解析成功: ", pk);

    // 用私钥解密数据
    const decryptedData = await decryptDataWithPrivateKey(pk, encryptedAesKey);
    // console.log("解密后的数据:", decryptedData);

    return decryptedData;
}

export { decryptMessage }