import { Button, SchemaForm } from 'formily-arco';
import { useCallback, useRef } from 'react';

const schema = {
  type: 'object',
  properties: {
    select: {
      type: 'string',
      'x-decorator': 'FormItem',
      'x-component': 'Select',
      'x-reactions': '{{useAsyncDataSource(loadData)}}',
    },
  },
}

const scope = {
  async loadData() {
    return new Promise((resolve) => {
      setTimeout(() => {
        resolve([
          {
            label: 'CCC',
            value: 'ccc',
          },
          {
            label: 'DDD',
            value: 'ddd',
          },
        ])
      }, 1000)
    })
  },
}

export function SlideForm (){
  const formRef = useRef<any>()
  const handleClick = useCallback(() => {
    console.log(formRef?.current?.getForm()?.values)
  }, [])
  return (
    <div className="p-[10px] bg-slate-50 max-h-full h-full">
      <SchemaForm ref={formRef} schema={schema} scope={scope} />
      <Button onClick={handleClick}>点击测试</Button>
    </div>
  )
}