import { Graph, Node } from '@antv/x6';
import { Button } from '@arco-design/web-react';
import { CustomProps } from '../context';

function StartNode(props: CustomProps) {
  return <Button type="primary">流程开始</Button>;
}

export default {
  shape: 'start-node',
  width: 180,
  height: 36,
  component: StartNode,
  ports: {
    groups: {
      top: {
        position: 'top',
        attrs: {
          circle: {
            r: 4,
            magnet: true,
            stroke: '#C2C8D5',
            strokeWidth: 1,
            fill: '#fff',
          },
        },
      },
      bottom: {
        position: 'bottom',
        attrs: {
          circle: {
            r: 4,
            magnet: true,
            stroke: '#C2C8D5',
            strokeWidth: 1,
            fill: '#fff',
          },
        },
      },
    },
  },
};
