import { precacheAndRoute } from 'workbox-precaching';
import { registerRoute } from 'workbox-routing';
import { NetworkFirst } from 'workbox-strategies';
import { clientsClaim, setCacheNameDetails, skipWaiting } from 'workbox-core';

// Workbox 会在这里插入预缓存列表
precacheAndRoute(self.__WB_MANIFEST);
skipWaiting(); // 跳过install 过程
clientsClaim(); // 激活所有的窗口

registerRoute(
    ({ url }) => {
        return url.href.startsWith('https://cdn.jsdelivr.net/npm');
    },
    ({ url, request, event }) => {
        const pattern = /npm\/react@\d+\.\d+\.\d+\/\+esm/;
        const pattern1 = /npm\/react-dom@\d+\.\d+\.\d+\/\+esm/;

        if (pattern.test(url.href)) {
            console.log(url.href, 'href');
            return event.respondWith(
                new Response(
                    `
// 使用模块导出语法导出这两个对象
const react = window.React || {};
export const Children = react.Children;
export const Component = react.Component;
export const Fragment = react.Fragment;
export const Profiler = react.Profiler;
export const PureComponent = react.PureComponent;
export const StrictMode = react.StrictMode;
export const Suspense = react.Suspense;
export const __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = react.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
export const cloneElement = react.cloneElement;
export const createContext = react.createContext;
export const createElement = react.createElement;
export const createFactory = react.createFactory;
export const createRef = react.createRef;
export const forwardRef = react.forwardRef;
export const isValidElement = react.isValidElement;
export const lazy = react.lazy;
export const memo = react.memo;
export const startTransition = react.startTransition;
export const unstable_act = react.unstable_act;
export const useCallback = react.useCallback;
export const useContext = react.useContext;
export const useDebugValue = react.useDebugValue;
export const useDeferredValue = react.useDeferredValue;
export const useEffect = react.useEffect;
export const useId = react.useId;
export const useImperativeHandle = react.useImperativeHandle;
export const useInsertionEffect = react.useInsertionEffect;
export const useLayoutEffect = react.useLayoutEffect;
export const useMemo = react.useMemo;
export const useReducer = react.useReducer;
export const useRef = react.useRef;
export const useState = react.useState;
export const useSyncExternalStore = react.useSyncExternalStore;
export const useTransition = react.useTransition;
export const version = react.version;
export default react

                `,
                    {
                        headers: { 'Content-Type': 'application/javascript' },
                    }
                )
            );
        } else if (pattern1.test(url.href)) {
            console.log(url.href, 'href');
            return event.respondWith(
                new Response(
                    `
// 使用模块导出语法导出这两个对象
const react = window.ReactDOM || {};
export const __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = react.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
export const createPortal = react.createPortal;
export const createRoot = react.createRoot;
export const findDOMNode = react.findDOMNode;
export const flushSync = react.flushSync;
export const hydrate = react.hydrate;
export const hydrateRoot = react.hydrateRoot;
export const render = react.render;
export const unmountComponentAtNode = react.unmountComponentAtNode;
export const unstable_batchedUpdates = react.unstable_batchedUpdates;
export const unstable_renderSubtreeIntoContainer = react.unstable_renderSubtreeIntoContainer;
export const version = react.version;
export default react
                `,
                    {
                        headers: { 'Content-Type': 'application/javascript' },
                    }
                )
            );
        }
        const strategy = new NetworkFirst();
        return strategy.handle({ request, event });
    }
);

// self.addEventListener('fetch', event => {
//     if (event.request.url.startsWith('https://data.jsdelivr.com/')) {
//         console.log('Fetching:', event.request.url);
//     }
// });

console.log(333);
