import { functions, get } from 'lodash';
export class XML {
    private root: HTMLDivElement;

    constructor(code: string) {
        this.root = document.createElement('div');
        this.root.innerHTML = code;
    }

    get(code: string): string {
        const insertText =
            (this.root.querySelector('FunctionCode') as HTMLElement)?.outerText || '';
        return insertText;
    }
}

export class FunctionsJson {
    private root: Record<string, any>;

    constructor(code: string) {
        try {
            this.root = JSON.parse(code);
        } catch {
            this.root = {};
        }
    }

    get(code: string): string {
        try {
            return JSON.parse(get(this.root, 'arguments', '{}'))[code] || '';
        } catch (e) {
            return '';
        }
    }
}
